/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzT;
import com.aspose.words.net.System.Data.zzU;
import com.aspose.words.net.System.Data.zzV;
import com.aspose.words.net.System.Data.zzX;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXNT = new DataRowCollection(this);
    private final DataColumnCollection zzXNS = new DataColumnCollection(this);
    private final ConstraintCollection zzXNR = new ConstraintCollection(this);
    private final zzT zzXNQ = new zzT(this);
    private ResultSet zzXNP;
    private String zzZbw;
    private DataSet zz4m;
    private String zzZ1p = "";
    private UniqueConstraint zzXNO;
    private boolean zzXO4 = true;
    private final List<DataTableEventListener> zzXNN = new ArrayList<DataTableEventListener>();
    private final Set<DataRow> zzXNM = new HashSet<DataRow>();

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZbw = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, zzY.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXNP = resultSet;
        this.zzZbw = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXNP != null) {
            if (this.zzXNP.getStatement() != null) {
                this.zzXNP.getStatement().getConnection().close();
            }
            this.zzXNP = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZbw;
    }

    public void setTableName(String tableName) {
        this.zzZbw = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXNS.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXNS.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXNP;
    }

    public DataSet getDataSet() {
        return this.zz4m;
    }

    final void zzZ(DataSet dataSet) {
        this.zz4m = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzXNT;
    }

    public DataColumnCollection getColumns() {
        return this.zzXNS;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXNR;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXNO == null) {
            return new DataColumn[0];
        }
        return this.zzXNO.getColumns();
    }

    final void zzU(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXNO != null) {
                this.zzXNO.zzQQ(false);
                this.getConstraints().remove(this.zzXNO);
                this.zzXNO = null;
            }
            return;
        }
        if (this.zzXNO != null && DataColumn.areColumnSetsTheSame(value, this.zzXNO.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXNO != null) {
            this.zzXNO.zzQQ(false);
            this.getConstraints().remove(this.zzXNO);
            this.zzXNO = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzXNO = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZ1p;
    }

    public void setNamespace(String namespace) {
        this.zzZ1p = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXO4;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXO4 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXNM.clear();
            this.getRows().clear();
            this.getColumns().clear();
            DataTable dataTable = this;
            ResultSet resultSet = this.getResultSet();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                String string = resultSetMetaData.getColumnName(i);
                DataColumn dataColumn = new DataColumn(string, dataTable, i);
                dataColumn.setAllowDBNull(resultSetMetaData.isNullable(i) == 1);
                dataColumn.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                try {
                    dataColumn.setDataType(Class.forName(resultSetMetaData.getColumnClassName(i)));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                dataTable.getColumns().add(dataColumn);
            }
            zzY.zzZ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzY(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXNN.contains(listener)) {
            this.zzXNN.add(listener);
        }
    }

    public void removeEventListener(zzX listener) {
        if (this.zzXNN.contains(listener)) {
            this.zzXNN.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXNN.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXNM.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXNN) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXNM.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXNN) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXNM.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXNN) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXNN) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXNN) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, DataRow dataRow) {
        DataTable dataTable;
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray3 = dataColumnArray2;
        DataColumn[] dataColumnArray4 = dataColumnArray;
        DataTable dataTable2 = dataTable = this;
        zzU zzU10 = dataTable.zzXNQ.zzX(dataColumnArray4);
        return zzU10.zzxa(zzV.zzZ(dataColumnArray3, dataRow2));
    }

    final zzT zzZ7x() {
        return this.zzXNQ;
    }

    final Set<DataRow> zzZ7w() {
        return this.zzXNM;
    }
}

