/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz2K;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzU;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzXOv;
    private final DataTable zzYJr;
    private final AtomicInteger zzXOu;

    ConstraintCollection(DataTable table) {
        this.zzYJr = table;
        this.zzXOu = new AtomicInteger(1);
        this.zzXOv = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zz2K.zzWZ(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzXOv) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzXOv.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzZ7G()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzZ7G()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzZ(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            ConstraintCollection constraintCollection = this;
            constraint.setConstraintName("Constraint" + constraintCollection.zzXOu.getAndIncrement());
        }
        constraint.zzZ(this);
        this.zzXOv.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzYJr.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzXOv.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzXOv.contains(cc);
    }

    public int getCount() {
        return this.zzXOv.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzXOv.iterator();
    }

    final DataTable getTable() {
        return this.zzYJr;
    }

    final List<ForeignKeyConstraint> zzZ7F() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzXOv) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzZ(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzXOv) {
            if (constraint instanceof UniqueConstraint) {
                DataRow dataRow2 = dataRow;
                UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
                ConstraintCollection constraintCollection = this;
                zzU zzU10 = constraintCollection.zzYJr.zzZ7x().zzX(uniqueConstraint.getColumns());
                Map<String, Object> map = zzU10.zzV(dataRow2);
                if (map != null && !map.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        stringBuilder.append(zz2K.format("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
                    }
                    throw new ConstraintException(stringBuilder.toString());
                }
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzZ((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzZ(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzXOv) {
            if (constraint2.equals(null) || zz2K.zzU(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private void zzZ(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzYJr.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzYJr.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        ConstraintCollection constraintCollection = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(constraintCollection.zzYJr.getTableName())) {
            return;
        }
        constraintCollection = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(constraintCollection.zzYJr.getTableName())) {
            return;
        }
        DataTable dataTable = foreignKeyConstraint.getRelatedTable();
        if (!dataTable.zzZ(foreignKeyConstraint.getRelatedColumns(), foreignKeyConstraint.getColumns(), dataRow)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                stringBuilder.append(zz2K.format("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
            }
            throw new InvalidConstraintException(stringBuilder.toString());
        }
    }
}

