/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzZC0;
import com.aspose.words.internal.zzZCO;
import com.aspose.words.internal.zzZCR;
import com.aspose.words.internal.zzZCS;
import com.aspose.words.internal.zzZDA;
import com.aspose.words.internal.zzZDN;
import com.aspose.words.internal.zzZDO;
import com.aspose.words.internal.zzZDQ;
import com.aspose.words.internal.zzZRV;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzZC1
extends CertPathBuilderSpi {
    private final zzZCS zzX0R;
    private zzZDA zzWYP;

    zzZC1(zzZCS zzZCS2) {
        this.zzX0R = zzZCS2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzZDN pkixParams;
        if (params instanceof zzZDN) {
            pkixParams = (zzZDN)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzZDN.zzZ((PKIXBuilderParameters)params).zzYW0();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzZDN.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZDO zzZDO2 = pkixParams.zzYW2().zzYVT();
        try {
            collection = zzZCR.zzZ(zzZDO2, pkixParams.zzYW2().zzYVZ());
            collection.addAll(zzZCR.zzZ(zzZDO2, pkixParams.zzYW2().getCertStores()));
        }
        catch (zzZDA zzZDA2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzZDA2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzZ(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzWYP != null) {
            throw new CertPathBuilderException(this.zzWYP.getMessage(), this.zzWYP.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzZ(X509Certificate x509Certificate, zzZDN zzZDN2, List list) throws CertPathBuilderException {
        zzZC0 zzZC02;
        zzZCO zzZCO2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzZDN2.zzYW1().contains(x509Certificate)) {
            return null;
        }
        if (zzZDN2.getMaxPathLength() != -1 && list.size() - 1 > zzZDN2.getMaxPathLength()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzZCO2 = new zzZCO(this.zzX0R);
            zzZC02 = new zzZC0(this.zzX0R);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzZCR.zzZ(x509Certificate, zzZDN2.zzYW2().getTrustAnchors(), zzZDN2.zzYW2().getSigProvider()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzZCO2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzZDA("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZC02.engineValidate(certPath, zzZDN2);
                }
                catch (Exception exception) {
                    throw new zzZDA("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzZDQ> arrayList = new ArrayList<zzZDQ>();
            arrayList.addAll(zzZDN2.zzYW2().zzYVZ());
            try {
                arrayList.addAll(zzZCR.zzZ(x509Certificate.getExtensionValue(zzZRV.zzXt0.getId()), zzZDN2.zzYW2().zzYVY()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzZDA("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzZCR.zzZ(x509Certificate, zzZDN2.zzYW2().getCertStores(), arrayList));
            }
            catch (zzZDA zzZDA2) {
                throw new zzZDA("Cannot find issuer certificate for certificate in certification path.", zzZDA2);
            }
            if (hashSet.isEmpty()) {
                throw new zzZDA("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzZ(x509Certificate2, zzZDN2, list);
            }
        }
        catch (zzZDA zzZDA3) {
            this.zzWYP = zzZDA3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

