/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.WordAttrCollection;
import com.aspose.words.internal.zz8D;
import com.aspose.words.internal.zzMU;
import com.aspose.words.internal.zzMV;
import com.aspose.words.internal.zzN2;
import com.aspose.words.internal.zzZ;
import com.aspose.words.internal.zzZK;
import com.aspose.words.zzX;
import com.aspose.words.zzYI;
import com.aspose.words.zzYUG;
import com.aspose.words.zzYUM;
import com.aspose.words.zzYUP;
import com.aspose.words.zzYUS;
import com.aspose.words.zzZM1;
import com.aspose.words.zzZPD;
import com.aspose.words.zzZYE;
import com.aspose.words.zzZZQ;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzY0a;
    private zzYUG zzZof;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        return (Row)this.zzrN();
    }

    public Row getLastRow() {
        return (Row)this.zzrM();
    }

    public RowCollection getRows() {
        if (this.zzY0a == null) {
            this.zzY0a = new RowCollection(this);
        }
        return this.zzY0a;
    }

    final boolean zzZcW() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            iterator.next();
            return true;
        }
        return false;
    }

    @Override
    final Node zzZ(boolean bl, zzZPD zzZPD2) {
        Table table = (Table)super.zzZ(bl, zzZPD2);
        if (this.zzZof != null) {
            table.zzZof = (zzYUG)this.zzZof.zzyO();
        }
        table.zzY0a = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    final Cell zzXH(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final int getColumnCount() {
        int n = 0;
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Row row2 = row;
            int n2 = 0;
            Cell cell = row2.getFirstCell();
            while (cell != null) {
                n2 += cell.zzwC().zzvF();
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZAM();
            }
            n = Math.max(n, n2);
            compositeNode = row;
            row = (Row)compositeNode.zzZAM();
        }
        return n;
    }

    final zzZM1 zzZcV() {
        zzYUM zzYUM2 = new zzYUM(this);
        return zzYUM2.zzZbJ();
    }

    final void zzZcU() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZpr()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzwE()) {
                switch (cell2.zzwC().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzwC().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            Cell cell3;
                            cell.zzwC().setWidth(cell.zzwC().getWidth() + cell2.zzwC().getWidth());
                            cell.zzwC().zzTl(cell.zzwC().zzvF() + cell2.zzwC().zzvF());
                            if (cell2.zzwC().getWidth() != 0 && cell.zzwC().getPreferredWidth().zzAH() && cell2.zzwC().getPreferredWidth().zzAH()) {
                                int n = cell.zzwC().getPreferredWidth().zzZqH() + cell2.zzwC().getPreferredWidth().zzZqH();
                                cell.zzwC().setPreferredWidth(PreferredWidth.zzCV(n));
                            }
                            if ((Cell)(cell3 = cell2).zzZAM() == null || ((Cell)(cell3 = cell2).zzZAM()).zzwC().getHorizontalMerge() != 2) {
                                Object object = cell2.zzwC().zzTK(3140);
                                if (object != null) {
                                    cell.zzwC().zzT(3140, object);
                                } else {
                                    cell.zzwC().remove(3140);
                                }
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzwC().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    final void zzZcT() {
        this.zzzf(0);
        if (this.zzZcQ()) {
            this.zzzf(1);
        }
    }

    private void zzzf(int n) {
        Object object;
        if (this.getFirstRow() == null) {
            return;
        }
        zzYUP zzYUP2 = new zzYUP(this, n == 1);
        if (zzYUP2.zzvm().length == 0) {
            return;
        }
        zzMV zzMV2 = new zzMV();
        zzMU zzMU2 = new zzMU();
        CompositeNode compositeNode = this.getFirstRow();
        while (compositeNode != null) {
            zzYUP2.zzD((Row)compositeNode);
            zzMV zzMV3 = new zzMV();
            zzMU<Object> zzMU3 = new zzMU<Object>();
            int n2 = zzYUP2.zzZg7();
            Object object2 = ((Row)compositeNode).getFirstCell();
            while (object2 != null) {
                int n3 = zzYUP2.zzZc7();
                if (Table.zzY((Cell)object2, n) != 0) {
                    boolean bl;
                    int n4 = zzMV2.get(n2);
                    if (zzMV.zzXm(n4)) {
                        n4 = 1;
                    }
                    if (n4 != n3 && n4 != ((Cell)object2).zzwC().zzvF()) {
                        ((Cell)object2).zzwC().zzZ(3030, 1, n);
                    }
                    if (bl = !((Row)compositeNode).zz4A().zzWZ(4120) && ((Row)compositeNode).getCells().getCount() == 1) {
                        CompositeNode compositeNode2 = compositeNode;
                        int n5 = ((Row)compositeNode2).getFirstCell().getLastParagraph() != null ? (int)(23.0 * ((Row)compositeNode2).getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : 276;
                        ((Row)compositeNode2).zz4A().zzT(4120, new zzZYE(0, n5));
                    }
                    zzMV3.set(n2, n3);
                    zzMU3.set(n2, object2);
                }
                n2 += ((Cell)object2).zzwC().zzvF();
                object = object2;
                object2 = (Cell)((Node)object).zzZAM();
            }
            object2 = zzMU3.zzNK();
            while (((zzMU.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzMU.zzZ)object2).zzNI();
                if (Table.zzY(cell, n) != 2 || zzMU2.get(((zzMU.zzZ)object2).zzNM()) != null) continue;
                cell.zzwC().zzZ(3030, 1, n);
            }
            object2 = zzMU2.zzNK();
            while (((zzMU.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzMU.zzZ)object2).zzNI();
                if (Table.zzY(cell, n) != 1 || zzMU3.get(((zzMU.zzZ)object2).zzNM()) != null) continue;
                cell.zzwC().zzZ(3030, 0, n);
            }
            zzMV2 = zzMV3;
            zzMU2 = zzMU3;
            object = compositeNode;
            compositeNode = (Row)((Node)object).zzZAM();
        }
        compositeNode = this.getLastRow().getFirstCell();
        while (compositeNode != null) {
            if (Table.zzY((Cell)compositeNode, n) == 1) {
                ((Cell)compositeNode).zzwC().zzZ(3030, 0, n);
            }
            object = compositeNode;
            compositeNode = (Cell)((Node)object).zzZAM();
        }
    }

    final void zzZcS() throws Exception {
        if (!this.isNested() || this.getFirstRow() == null) {
            return;
        }
        Table table = (Table)this.getAncestor(5);
        boolean bl = table.getAllowAutoFit();
        if (bl != this.getAllowAutoFit()) {
            if (!bl) {
                this.zzZcV();
            }
            this.setAllowAutoFit(bl);
        }
    }

    private static int zzY(Cell cell, int n) {
        return (Integer)cell.zzwC().zzXY(3030, n);
    }

    final int zz5S() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYI zzYI2 = row.getFirstCell().zzwC();
        boolean bl = this.isNested();
        zzYI zzYI3 = zzYI2;
        zzYUG zzYUG2 = row.zz4A();
        return zzYUG2.zzZFE() - zzYUG2.zzY(zzYI3, bl);
    }

    @Override
    final boolean zzh(Node node) {
        return zzX.zzJ(node);
    }

    final boolean isNested() {
        if (this.zzZAT() == null) {
            return false;
        }
        return this.zzZAT().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzzc(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzv(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzzc(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        if (value != this.getAllowAutoFit()) {
            this.zzZcO();
        }
        this.zzv(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzzc(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzv(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzzc(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzv(4380, value);
    }

    public double getLeftPadding() {
        int n = (Integer)this.zzzc(4020);
        return (double)n / 20.0;
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzv(4020, zzZ.zzU(value));
    }

    public double getRightPadding() {
        int n = (Integer)this.zzzc(4320);
        return (double)n / 20.0;
    }

    public void setRightPadding(double value) throws Exception {
        this.zzv(4320, zzZ.zzU(value));
    }

    public double getTopPadding() {
        int n = (Integer)this.zzzc(4300);
        return (double)n / 20.0;
    }

    public void setTopPadding(double value) throws Exception {
        this.zzv(4300, zzZ.zzU(value));
    }

    public double getBottomPadding() {
        int n = (Integer)this.zzzc(4310);
        return (double)n / 20.0;
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzv(4310, zzZ.zzU(value));
    }

    public double getCellSpacing() {
        int n = (Integer)this.zzzc(4290);
        return (double)n / 20.0;
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzv(4290, zzZ.zzU(value));
    }

    public boolean getAllowCellSpacing() {
        return this.getFirstRow().hasAttribute(4290);
    }

    public void setAllowCellSpacing(boolean value) throws Exception {
        if (value) {
            if (!this.getAllowCellSpacing()) {
                this.zzv(4290, 7);
                return;
            }
        } else {
            this.zzze(4290);
        }
    }

    public double getLeftIndent() {
        int n = (Integer)this.zzzc(4340);
        return (double)n / 20.0;
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzv(4340, zzZ.zzU(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzzc(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzv(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXK(this.zzZTk(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        int n = value.zzZTk();
        Table table = this;
        table.zzv(4005, n);
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzJJ(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzzD(value));
    }

    public int getTextWrapping() {
        if (this.isFloating()) {
            return 1;
        }
        return 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            Table table = this;
            zzYUG zzYUG2 = table.getFirstRow().zz4A();
            table.zzv(4160, 2);
            table.zzv(4190, 0);
            table.zzv(4210, 180);
            table.zzv(4270, 180);
            table.zzv(4350, false);
            int n = (Integer)zzYUG2.zzTJ(4010);
            if (n == 2) {
                table.zzv(4180, 3);
            } else if (n == 1) {
                table.zzv(4180, 2);
            }
            table.zzze(4010);
            if (zzYUG2.contains(4340)) {
                int n2 = (Integer)zzYUG2.zzTK(4340);
                table.zzv(4170, n2 - 1);
            }
            table.zzze(4340);
            return;
        }
        Table table = this;
        zzYUG zzYUG3 = table.getFirstRow().zz4A();
        int n = (Integer)zzYUG3.zzTJ(4180);
        if (n == 3) {
            table.zzv(4010, 2);
        } else if (n == 2) {
            table.zzv(4010, 1);
        }
        table.zzze(4170);
        table.zzze(4160);
        table.zzze(4150);
        table.zzze(4190);
        table.zzze(4210);
        table.zzze(4270);
        table.zzze(4350);
        table.zzze(4180);
        table.zzze(4200);
    }

    public String getTitle() {
        return (String)this.zzzc(5000);
    }

    public void setTitle(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        this.zzv(5000, value);
    }

    public String getDescription() {
        return (String)this.zzzc(5010);
    }

    public void setDescription(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        this.zzv(5010, value);
    }

    public double getDistanceLeft() {
        int n = (Integer)this.zzzc(4210);
        return (double)n / 20.0;
    }

    public double getDistanceRight() {
        int n = (Integer)this.zzzc(4270);
        return (double)n / 20.0;
    }

    public double getDistanceTop() {
        int n = (Integer)this.zzzc(4220);
        return (double)n / 20.0;
    }

    public double getDistanceBottom() {
        int n = (Integer)this.zzzc(4280);
        return (double)n / 20.0;
    }

    public int getRelativeHorizontalAlignment() {
        return (Integer)this.zzzc(4180);
    }

    public int getRelativeVerticalAlignment() {
        return (Integer)this.zzzc(4200);
    }

    public int getHorizontalAnchor() {
        return (Integer)this.zzzc(4150);
    }

    public int getVerticalAnchor() {
        return (Integer)this.zzzc(4160);
    }

    public double getAbsoluteHorizontalDistance() {
        int n = (Integer)this.zzzc(4170);
        return (double)n / 20.0;
    }

    public double getAbsoluteVerticalDistance() {
        int n = (Integer)this.zzzc(4190);
        return (double)n / 20.0;
    }

    public boolean getAllowOverlap() {
        return (Boolean)this.zzzc(4350);
    }

    final int zzZTk() {
        return (Integer)this.zzzc(4005);
    }

    final boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zz4A().isFloating();
    }

    final zzYUG zz4A() {
        if (this.zzZof == null) {
            this.zzZof = new zzYUG();
        }
        return this.zzZof;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYUG.zzZWg.zzDK().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            int n = borderType;
            Table table = this;
            switch (n) {
                case 3: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzwC().remove(3110);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZAM();
                    }
                    break;
                }
                case 0: {
                    CompositeNode compositeNode;
                    Row row = table.getLastRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzwC().remove(3130);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZAM();
                    }
                    break;
                }
                case 1: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        if (cell != null) {
                            cell.zzwC().remove(3120);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZAM();
                    }
                    break;
                }
                case 2: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getLastCell();
                        if (cell != null) {
                            cell.zzwC().remove(3140);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZAM();
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        boolean bl2 = !row.isFirstRow();
                        bl = !row.isLastRow();
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            if (bl2) {
                                cell.zzwC().remove(3110);
                            }
                            if (bl) {
                                cell.zzwC().remove(3130);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZAM();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZAM();
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            boolean bl3;
                            bl = !cell.isFirstCell();
                            boolean bl4 = bl3 = !cell.isLastCell();
                            if (bl) {
                                cell.zzwC().remove(3120);
                            }
                            if (bl3) {
                                cell.zzwC().remove(3140);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZAM();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZAM();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected border type.");
                }
            }
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZpr()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            WordAttrCollection wordAttrCollection = row.zz4A();
            for (int n : zzYUG.zzZWg.zzDJ()) {
                wordAttrCollection.remove(n);
            }
            Cell cell = row.getFirstCell();
            while (cell != null) {
                wordAttrCollection = cell.zzwC();
                for (int n : zzYI.zzZWg.zzDJ()) {
                    wordAttrCollection.remove(n);
                }
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZAM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZAM();
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZAM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZAM();
        }
    }

    public void clearShading() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            WordAttrCollection wordAttrCollection = row.zz4A();
            wordAttrCollection.remove(4330);
            Cell cell = row.getFirstCell();
            while (cell != null) {
                wordAttrCollection = cell.zzwC();
                wordAttrCollection.remove(3170);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZAM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZAM();
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzze(4230);
                table.zzzd(3020);
                table.zzZcV();
                return;
            }
            case 1: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzv(4230, PreferredWidth.fromPercent(100.0));
                table.zzzd(3020);
                table.zzZcV();
                return;
            }
            case 2: {
                Table table = this;
                table.setAllowAutoFit(false);
                table.setPreferredWidth(PreferredWidth.AUTO);
                table.zzZcO();
                Table table2 = table;
                Row row = table2.getFirstRow();
                while (row != null) {
                    CompositeNode compositeNode;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        PreferredWidth preferredWidth;
                        Object object = cell.zzwC().zzTK(3010);
                        int n = object == null ? 0 : (Integer)object;
                        if (n <= 0 && (preferredWidth = cell.getCellFormat().getPreferredWidth()).zzAH()) {
                            n = preferredWidth.zzZqH();
                            cell.zzwC().setWidth(n);
                        }
                        if (n <= 0) {
                            n = 360 * cell.zzwC().zzvF();
                            cell.zzwC().zzT(3010, n);
                        }
                        cell.zzwC().setPreferredWidth(PreferredWidth.zzCV(n));
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZAM();
                    }
                    compositeNode = row;
                    row = (Row)compositeNode.zzZAM();
                }
                table.zzZcP();
                return;
            }
        }
        throw new IllegalArgumentException("Unknown auto fit behavior.");
    }

    final int zzZcR() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzwC().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    final boolean zzZcQ() {
        for (Row row : this.getRows()) {
            if (row.zz4A().hasRevisions()) {
                return true;
            }
            for (Cell cell : row.getCells()) {
                if (!cell.zzwC().hasRevisions()) continue;
                return true;
            }
        }
        return false;
    }

    final void zzze(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            row.zz4A().remove(n);
            Row row2 = row;
            row = (Row)row2.zzZAM();
        }
    }

    final void zzv(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZpr()) {
            if (n == 4005) {
                Row row2 = row;
                Table table = this;
                Object object2 = row2.zz4A().get(4120);
                Object object3 = row2.zz4A().get(4240);
                Object object4 = row2.zz4A().get(4230);
                row2.getRowFormat().clearFormatting();
                table.zzzd(3060);
                if (object2 != null) {
                    row2.zz4A().zzT(4120, object2);
                }
                if (object3 != null) {
                    row2.zz4A().zzT(4240, object3);
                }
                if (object4 != null) {
                    row2.zz4A().zzT(4230, object4);
                }
            }
            row.zz4A().zzT(n, object);
        }
    }

    private void zzzd(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                cell.zzwC().remove(n);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZAM();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZAM();
        }
    }

    final void zzZcP() {
        zzYUS zzYUS2 = this.zz4A().zzZba();
        if (zzYUS.zzZ(zzYUS2) && this.zz4A().zzTK(5103) != null) {
            return;
        }
        zzYUP zzYUP2 = new zzYUP(this, false);
        zzYUP zzYUP3 = new zzYUP(this, true);
        this.zz4A().zzT(5103, new zzN2(zzYUP2.zzvm()));
        for (Row row : this.getRows()) {
            zzYUP2.zzD(row);
            Table.zzZ(row.zz4A(), zzYUP2);
            for (Object object : row.getCells()) {
                ((Cell)object).zzwC().zzT(3900, zzYUP2.zzZc7());
            }
        }
        if (zzZK.zzV(zzYUP2.zzvm(), zzYUP3.zzvm())) {
            zzYUG zzYUG2 = this.zz4A();
            zzYUG2.remove(10010);
            return;
        }
        if (this.zz4A().zzZpM() == null) {
            this.zz4A().zzZ(new zzZZQ(new zzYUG(), "", zz8D.zzjl));
        }
        this.zz4A().zzZb7().zzT(5103, new zzN2(zzYUP3.zzvm()));
        for (Row row : this.getRows()) {
            zzYUG zzYUG3 = row.zz4A().zzZb7();
            zzYUP3.zzD(row);
            Table.zzZ(zzYUG3, zzYUP3);
            for (Cell cell : row.getCells()) {
                cell.zzwC().zzvH().zzT(3900, zzYUP3.zzZc7());
            }
        }
    }

    private static void zzZ(zzYUG zzYUG2, zzYUP zzYUP2) {
        zzYUG2.zzT(5104, zzYUP2.zzZg7());
        zzYUG2.zzT(5105, zzYUP2.zzZg8());
        zzYUG2.zzyW(zzYUP2.zzZFb());
        zzYUG2.zzH6(zzYUP2.zzZFa());
    }

    private void zzZcO() {
        if (this.zz4A().zzZba() != null) {
            this.zz4A().remove(5106);
        }
    }

    private Object zzzc(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYUG.zzTk(n);
        }
        if (n == 4005) {
            if (row.zz4A() != null) {
                return row.zz4A().zzZTk();
            }
            return zzYUG.zzTk(4005);
        }
        return row.fetchRowAttr(n);
    }
}

