/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz74;
import com.aspose.words.internal.zz77;
import com.aspose.words.internal.zzC2;
import com.aspose.words.internal.zzRS;
import com.aspose.words.internal.zzW;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zz14;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZ8k = new HashMap();
    private static HashMap<Integer, Integer> zzZ8j = new HashMap();
    private static HashMap<Integer, Integer> zzZ8i = new HashMap();
    private static HashMap<Integer, Integer> zzZ8h = new HashMap();
    private static HashMap<Integer, Integer> zzZ8g = new HashMap();
    private static HashMap<Integer, Integer> zzZ8f = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ.zzZ(fileName, "fileName");
        zz77 zz772 = zzZ.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz6(zz772);
            return fileFormatInfo;
        }
        finally {
            ((zz74)zz772).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz6(zzW.zzZ(stream));
    }

    static FileFormatInfo zz6(zz74 zz742) throws Exception {
        if (zz742 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz14 zz142 = new zz14();
            zz74 zz743 = zz742;
            zz14 zz143 = zz142;
            return zz142.zzY(zz743, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzKL(zzRS.zzh(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzKQ(zzRS.zzh(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzRS.zzXM(FileFormatUtil.zzKN(loadFormat));
        if (zzC2.zzYF(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzKL(FileFormatUtil.zzKM(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzKQ(FileFormatUtil.zzKN(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzRS.zzXM(FileFormatUtil.zzKM(saveFormat));
        if (zzC2.zzYF(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzKQ(zzRS.zzg(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        return "." + zzRS.zzXM(zzZ.zzZ(zzZ8i, Integer.valueOf(n), Integer.valueOf(0)));
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzKR(int n) {
        return zzRS.toString(FileFormatUtil.zzKM(n));
    }

    static int zzKQ(int n) {
        return zzZ.zzZ(zzZ8g, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzKP(int n) {
        return zzZ.zzZ(zzZ8f, Integer.valueOf(n), Integer.valueOf(1));
    }

    static boolean zzKO(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzKN(int n) {
        return zzZ.zzZ(zzZ8k, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzKM(int n) {
        return zzZ.zzZ(zzZ8j, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzKL(int n) {
        return zzZ.zzZ(zzZ8h, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzQ(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZ.zzY(zzZ8g, Integer.valueOf(n), Integer.valueOf(n2));
            zzZ.zzY(zzZ8j, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZ8h.containsKey(n)) {
                zzZ.zzY(zzZ8h, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZ.zzY(zzZ8k, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZ.zzY(zzZ8f, Integer.valueOf(n), Integer.valueOf(n4));
            zzZ.zzY(zzZ8i, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzQ(11, 10, 10, 1);
        FileFormatUtil.zzQ(11, 0, 0, 1);
        FileFormatUtil.zzQ(12, 11, 11, 1);
        FileFormatUtil.zzQ(13, 20, 20, 1);
        FileFormatUtil.zzQ(13, 0, 254, 1);
        FileFormatUtil.zzQ(14, 21, 21, 1);
        FileFormatUtil.zzQ(15, 22, 22, 1);
        FileFormatUtil.zzQ(16, 23, 23, 1);
        FileFormatUtil.zzQ(18, 24, 24, 1);
        FileFormatUtil.zzQ(19, 25, 25, 1);
        FileFormatUtil.zzQ(20, 26, 26, 1);
        FileFormatUtil.zzQ(21, 27, 27, 1);
        FileFormatUtil.zzQ(24, 30, 30, 1);
        FileFormatUtil.zzQ(17, 31, 31, 1);
        FileFormatUtil.zzQ(25, 50, 50, 1);
        FileFormatUtil.zzQ(26, 45, 255, 1);
        FileFormatUtil.zzQ(27, 51, 51, 1);
        FileFormatUtil.zzQ(28, 0, 52, 1);
        FileFormatUtil.zzQ(22, 60, 60, 1);
        FileFormatUtil.zzQ(23, 61, 61, 1);
        FileFormatUtil.zzQ(31, 40, 255, 1);
        FileFormatUtil.zzQ(38, 47, 255, 1);
        FileFormatUtil.zzQ(39, 48, 255, 1);
        FileFormatUtil.zzQ(32, 41, 255, 1);
        FileFormatUtil.zzQ(33, 46, 255, 1);
        FileFormatUtil.zzQ(35, 42, 255, 1);
        FileFormatUtil.zzQ(34, 44, 255, 1);
        FileFormatUtil.zzQ(29, 52, 255, 1);
        FileFormatUtil.zzQ(30, 70, 62, 1);
        FileFormatUtil.zzQ(36, 71, 255, 1);
        FileFormatUtil.zzQ(8, 100, 255, 1);
        FileFormatUtil.zzQ(9, 105, 255, 1);
        FileFormatUtil.zzQ(6, 101, 255, 6);
        FileFormatUtil.zzQ(7, 102, 255, 7);
        FileFormatUtil.zzQ(5, 104, 255, 5);
        FileFormatUtil.zzQ(4, 0, 255, 4);
        FileFormatUtil.zzQ(3, 0, 255, 3);
        FileFormatUtil.zzQ(37, 72, 255, 1);
        FileFormatUtil.zzQ(2, 103, 255, 2);
    }
}

