/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzXOj;
    private DataTable zzXOi;
    private DataTable zzXOh;
    private String zz9M;
    private String zz9L;
    private String[] zzXOg;
    private String[] zzXOf;
    private DataColumn[] zzXOe;
    private DataColumn[] zzXOd;
    private UniqueConstraint zzXOc;
    private ForeignKeyConstraint zzXOb;
    private boolean zzXOa = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzXOj = relationName;
        this.zzXOi = parentTable;
        this.zzXOh = childTable;
        this.zz9M = parentTable.getTableName();
        this.zz9L = childTable.getTableName();
        this.zzXOg = parentColumnNames;
        this.zzXOf = childColumnNames;
        this.zzXOe = new DataColumn[this.zzXOg.length];
        for (n = 0; n < this.zzXOg.length; ++n) {
            this.zzXOe[n] = new DataColumn(this.zzXOg[n], this.zzXOi);
        }
        this.zzXOd = new DataColumn[this.zzXOf.length];
        for (n = 0; n < this.zzXOf.length; ++n) {
            this.zzXOd[n] = new DataColumn(this.zzXOf[n], this.zzXOh);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzXOj = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzXOe = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzXOd = childColumns;
        this.zzXOa = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzXOd.length; ++n) {
            DataColumn dataColumn2 = childColumns[n];
            DataColumn dataColumn3 = parentColumns[n];
            if (dataColumn3.getDataType() == dataColumn2.getDataType()) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzXOg = new String[this.zzXOe.length];
        for (n = 0; n < this.zzXOe.length; ++n) {
            this.zzXOg[n] = this.zzXOe[n].getColumnName();
        }
        this.zzXOf = new String[this.zzXOd.length];
        for (n = 0; n < this.zzXOd.length; ++n) {
            this.zzXOf[n] = this.zzXOd[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzXOj;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzXOi != null) {
            return this.zzXOi;
        }
        return this.zzXOe[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzXOh != null) {
            return this.zzXOh;
        }
        return this.zzXOd[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzXOg;
    }

    public String[] getChildColumnNames() {
        return this.zzXOf;
    }

    public DataColumn[] getParentColumns() {
        return this.zzXOe;
    }

    public DataColumn[] getChildColumns() {
        return this.zzXOd;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzXOc;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzXOc = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzXOb;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzXOb = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzXOj.hashCode();
        n = n * 31 + this.zz9M.hashCode();
        n = n * 31 + this.zz9L.hashCode();
        for (int i = 0; i < this.zzXOg.length; ++i) {
            n = n * 31 + this.zzXOg[i].hashCode();
            n = n * 31 + this.zzXOf[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzZ7D() throws InvalidConstraintException, DataException {
        UniqueConstraint uniqueConstraint;
        Constraint constraint;
        ForeignKeyConstraint foreignKeyConstraint;
        block6: {
            ForeignKeyConstraint foreignKeyConstraint2;
            Constraint constraint2;
            DataRelation dataRelation;
            ConstraintCollection constraintCollection;
            block5: {
                if (!this.zzXOa) {
                    return;
                }
                constraintCollection = this.getChildTable().getConstraints();
                dataRelation = this;
                for (Constraint constraint3 : constraintCollection) {
                    if (!(constraint3 instanceof ForeignKeyConstraint)) continue;
                    constraint2 = (ForeignKeyConstraint)constraint3;
                    if (!DataRelation.zzZ(dataRelation.getChildColumns(), ((ForeignKeyConstraint)constraint2).getColumns()) || !DataRelation.zzZ(dataRelation.getParentColumns(), ((ForeignKeyConstraint)constraint2).getRelatedColumns())) continue;
                    foreignKeyConstraint2 = constraint2;
                    break block5;
                }
                foreignKeyConstraint2 = null;
            }
            foreignKeyConstraint = foreignKeyConstraint2;
            constraintCollection = this.getParentTable().getConstraints();
            dataRelation = this;
            for (Constraint constraint3 : constraintCollection) {
                if (!(constraint3 instanceof UniqueConstraint)) continue;
                constraint2 = (UniqueConstraint)constraint3;
                if (!DataRelation.zzZ(dataRelation.getParentColumns(), ((UniqueConstraint)constraint2).getColumns())) continue;
                constraint = constraint2;
                break block6;
            }
            constraint = uniqueConstraint = null;
        }
        if (constraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private static boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

