/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zz2K;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXZu = new ArrayList();
    private final Map<String, DataColumn> zzXOk = new HashMap<String, DataColumn>();
    private DataTable zzYJr;

    DataColumnCollection(DataTable table) {
        this.zzYJr = table;
    }

    public void add(DataColumn column) {
        if (zz2K.zzWZ(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.normalize(column.getColumnName());
        if (this.zzXOk.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzZ(this.zzYJr);
        column.setOrdinal(this.zzXZu.size());
        this.zzXZu.add(column);
        this.zzXOk.put(string, column);
        this.zzYJr.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYJr);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zz2K.zzWZ(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.normalize(columnName);
        DataColumn dataColumn = this.zzXOk.get(string);
        if (dataColumn != null) {
            int n = this.zzXZu.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXZu.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXZu.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXZu.remove(n);
            this.zzXOk.remove(DataColumnCollection.normalize(dataColumn.getColumnName()));
            this.zzYJr.onDataColumnDeleted(dataColumn);
        }
    }

    public int getCount() {
        return this.zzXZu.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXZu.iterator();
    }

    public void clear() {
        this.zzXOk.clear();
        this.zzXZu.clear();
    }

    final DataColumn[] zzZ7E() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXZu);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzZ(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXZu.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXZu.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.normalize(string);
            String string3 = DataColumnCollection.normalize(dataColumn.getColumnName());
            this.zzXOk.remove(string3);
            this.zzXOk.put(string2, dataColumn);
            return;
        }
    }

    private static String normalize(String columnName) {
        return Normalizer.normalize(columnName.toLowerCase(), Normalizer.Form.NFD);
    }
}

