/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zz75;
import com.aspose.words.internal.zzRS;

public abstract class SaveOptions {
    private boolean zzY9h = false;
    private boolean zzY9g = true;
    private boolean zzFD;
    private String zzY9f;
    private boolean zzY9e;
    private boolean zzY9d = false;
    private boolean zzY9c = true;
    private int zzY9b = 1;
    private int zzYVn = 0;
    private int zzEG = 0;
    private String zzY9a = "";
    private boolean zzY99 = true;
    private boolean zzY98 = true;
    private boolean zzY97;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZOI() {
        return false;
    }

    boolean zzZUq() {
        return true;
    }

    final boolean zzZl2() {
        return this.zzY9g;
    }

    public String getTempFolder() {
        return this.zzY9f;
    }

    public void setTempFolder(String value) {
        this.zzY9f = value;
    }

    public boolean getPrettyFormat() {
        return this.zzFD;
    }

    public void setPrettyFormat(boolean value) {
        this.zzFD = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzY9e;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzY9e = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzY9d;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzY9d = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzY9c;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzY9c = value;
    }

    public int getColorMode() {
        return this.zzEG;
    }

    public void setColorMode(int value) {
        this.zzEG = value;
    }

    public int getDmlRenderingMode() {
        return this.zzY9b;
    }

    public void setDmlRenderingMode(int value) {
        this.zzY9b = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYVn;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYVn = value;
    }

    public String getDefaultTemplate() {
        return this.zzY9a;
    }

    public void setDefaultTemplate(String value) {
        this.zzY9a = value;
    }

    public boolean getUpdateFields() {
        return this.zzY99;
    }

    public void setUpdateFields(boolean value) {
        this.zzY99 = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzY97;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzY97 = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzY9h;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzY9h = value;
    }

    final boolean zzZl1() {
        return this.zzY98;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzKQ(zzRS.zzg(zz75.zzXD(fileName))));
    }
}

