/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZ;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzZFA;
import com.aspose.words.zzZFR;
import com.aspose.words.zzZFY;
import com.aspose.words.zzZPC;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZPC,
Iterable<T> {
    private CompositeNode zzYDf;
    private DocumentBase zzZYJ;
    private boolean zzZc7;
    private int zzYDe;
    private int zzYDd;
    private Node zzYDc;
    private int zzZI;
    private zzZFR zzYDb;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZFA(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZFA(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZFR matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzYDf = container;
        this.zzZYJ = container.getDocument();
        this.zzYDb = matcher;
        this.zzZc7 = isDeep;
        this.invalidate();
    }

    public Node get(int index) {
        try {
            Node node;
            Node node2;
            block7: {
                boolean bl;
                int n;
                this.zzZAA();
                if (index < 0 && (index = this.getCount() + index) < 0) {
                    return null;
                }
                if (this.zzYDd == index) {
                    return this.zzYDc;
                }
                int n2 = n = index - this.zzYDd;
                Node node3 = this.zzYDc;
                NodeCollection nodeCollection = this;
                boolean bl2 = bl = n2 > 0;
                if (n2 < 0) {
                    n2 = -n2;
                }
                Node node4 = node3;
                for (int i = 0; i < n2; ++i) {
                    Ref<Node> ref = new Ref<Node>(node4);
                    nodeCollection.zzZ(ref, bl);
                    node4 = ref.get();
                    if (node4 != null) continue;
                    node2 = null;
                    break block7;
                }
                node2 = node = node4;
            }
            if (node2 != null) {
                this.zzYDd = index;
                this.zzYDc = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZc7) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzYDf.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZc7) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzYDf.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzZAB();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZFY(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzZAB() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZ.zzZ(arrayList, node);
        }
        return arrayList;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) throws Exception {
        return this.zzZ(curNode, true);
    }

    private Node zzZ(Ref<Node> ref, boolean bl) throws Exception {
        Node node;
        ref.get();
        do {
            Node node2;
            NodeCollection nodeCollection;
            boolean bl2;
            Node node3;
            node = ref.get();
            if (this.zzZc7) {
                node3 = ref.get();
                bl2 = bl;
                nodeCollection = this;
                node2 = bl2 ? node3.nextPreOrder(nodeCollection.zzYDf) : node3.previousPreOrder(nodeCollection.zzYDf);
            } else if (this.zzYDb.zzsI()) {
                Node node4;
                node3 = ref.get();
                bl2 = bl;
                nodeCollection = this;
                if (bl2) {
                    node4 = node3 == nodeCollection.zzYDf ? nodeCollection.zzYDf.zzrP() : node3.zzZAO();
                } else {
                    Node node5 = node4 = node3 == nodeCollection.zzYDf ? nodeCollection.zzYDf.zzrO() : node3.zzZAP();
                }
                if (node4 == nodeCollection.zzYDf.getNextSibling() || node4 == nodeCollection.zzYDf.getPreviousSibling()) {
                    node4 = null;
                }
                node2 = node4;
            } else {
                node3 = ref.get();
                bl2 = bl;
                nodeCollection = this;
                node2 = bl2 ? (node3 == nodeCollection.zzYDf ? nodeCollection.zzYDf.getFirstChild() : node3.getNextSibling()) : (node3 == nodeCollection.zzYDf ? nodeCollection.zzYDf.getLastChild() : node3.getPreviousSibling());
            }
            ref.set(node2);
        } while (ref.get() != null && !this.zzYDb.zzg(ref.get()));
        return node;
    }

    private void zzZAA() {
        if (this.zzYDe != this.zzZAz()) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.zzYDe = this.zzZAz();
        this.zzYDd = -1;
        this.zzYDc = this.zzYDf;
        this.zzZI = -1;
    }

    private int zzZAz() {
        if (this.zzZYJ != null) {
            return this.zzZYJ.zz51();
        }
        return 0;
    }

    public int getCount() {
        this.zzZAA();
        if (this.zzZI == -1) {
            this.zzZI = zzZFY.zzZ(this);
        }
        return this.zzZI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzYDf;
    }
}

