/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zz2K;
import com.aspose.words.internal.zz74;
import com.aspose.words.internal.zz75;
import com.aspose.words.internal.zz76;
import com.aspose.words.internal.zz7D;
import com.aspose.words.internal.zz8F;
import com.aspose.words.internal.zzA8;
import com.aspose.words.internal.zzA9;
import com.aspose.words.internal.zzBL;
import com.aspose.words.internal.zzC2;
import com.aspose.words.internal.zzYH;
import com.aspose.words.internal.zzYT;
import com.aspose.words.internal.zzYU;
import com.aspose.words.internal.zzZ;
import com.aspose.words.zz37;
import com.aspose.words.zz3C;
import com.aspose.words.zz7;
import com.aspose.words.zz96;
import com.aspose.words.zzDA;
import com.aspose.words.zzDY;
import com.aspose.words.zzE4;
import com.aspose.words.zzFW;
import com.aspose.words.zzIA;
import com.aspose.words.zzMJ;
import com.aspose.words.zzX;
import com.aspose.words.zzYI;
import com.aspose.words.zzYPE;
import com.aspose.words.zzYRX;
import com.aspose.words.zzYUG;
import com.aspose.words.zzYUY;
import com.aspose.words.zzYVJ;
import com.aspose.words.zzYVW;
import com.aspose.words.zzYZJ;
import com.aspose.words.zzZ0Q;
import com.aspose.words.zzZ7K;
import com.aspose.words.zzZ8E;
import com.aspose.words.zzZ8I;
import com.aspose.words.zzZHH;
import com.aspose.words.zzZK;
import com.aspose.words.zzZOR;
import com.aspose.words.zzZOU;
import com.aspose.words.zzZQ3;
import com.aspose.words.zzZRU;
import com.aspose.words.zzZRW;
import com.aspose.words.zzZUF;
import com.aspose.words.zzZV1;
import com.aspose.words.zzZWK;
import com.aspose.words.zzZZR;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzZOR,
zzZOU,
zzZRW {
    private Document zzZpO;
    private Node zzZok;
    private Node zzZoj;
    private zzZ0Q zzZoi;
    private Font zzZoh;
    private zz8F<zzZ0Q> zzZog;
    private zzYUG zzZof = zzYUG.zzZbk();
    private zzYI zzZWz = new zzYI();
    private RowFormat zzZoe;
    private CellFormat zzZWy;
    private zz8F<zzYUY> zzZod;
    private int zzZoc = 0;
    private int zzZob = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzR(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzR(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzR(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.zzZ(this.getCurrentSection(), zzYPE.zzxk(headerFooterType), 0, 0);
    }

    private void zzR(int n, int n2, int n3, int n4) {
        this.zzZpO.ensureMinimum();
        Section section = (Section)this.zzZpO.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYPE.zzxj(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZpO, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZpO));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzY(paragraph, n2);
    }

    final void zzY(Paragraph paragraph, int n) {
        if (n == 0) {
            this.zzZ(paragraph, paragraph.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz4B().isRemoved() ? zzZHH.zzT(this.zzZpO, fieldName) : zzZHH.zzS(this.zz4B(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZQ3 zzZQ32 = field.getFormat().zzZXh();
        Inline inline = zzZQ32.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzZXi(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZK.zzX(this.zzZpO, bookmarkName) : zzZK.zzW(this.zzZpO, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZAF() == 6) {
            this.zzZ((Paragraph)node.zzZAT(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzX.zzC(node);
            if (paragraph == null) {
                return false;
            }
            this.zzZ(paragraph, paragraph.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZ6(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzY(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzY(cell.getLastParagraph(), -1);
        }
    }

    private void zzZ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZAF() == 6) {
            this.zz7(node);
        } else if (zzX.zzN(node)) {
            Paragraph paragraph = zzX.zzC(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zz7(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzZAF() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zz7(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zz4M();
            return;
        }
        if (!this.zz4N()) {
            this.zz4M();
        }
    }

    private boolean zz4N() {
        Node node = this.zz4B();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz4B(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ(inline.zzZXi(), true);
            return true;
        }
        return false;
    }

    private void zz4M() {
        this.zzZ(this.getCurrentParagraph().zzZsc(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ6(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz4E() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz4B().zzZ5(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZAM();
                this.zzY(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzH(text, false);
    }

    public void writeln(String text) {
        this.zzH(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYVJ zzYVJ2 = new zzYVJ(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZpO, this.zz4J(), this.zz4K());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zz4B(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYVJ2.dispose();
        }
        if (this.getDocument().zz5b()) {
            zzX.zzX(paragraph, this.getDocument().zz5g());
        }
        return this.getCurrentParagraph();
    }

    public void insertStyleSeparator() {
        zzYVW.zzY(this);
    }

    public void insertBreak(int breakType) {
        this.zzn(breakType, true);
    }

    final void zzn(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXt(bl)) {
                    this.zzSz(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXt(bl)) {
                    this.zzSz(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzXt(bl)) {
                    this.zzNz(1);
                }
                return;
            }
            case 5: {
                if (this.zzXt(bl)) {
                    this.zzNz(2);
                }
                return;
            }
            case 3: {
                if (this.zzXt(bl)) {
                    this.zzNz(0);
                }
                return;
            }
            case 6: {
                if (this.zzXt(bl)) {
                    this.zzNz(3);
                }
                return;
            }
            case 7: {
                if (this.zzXt(bl)) {
                    this.zzNz(4);
                }
                return;
            }
            case 8: {
                this.zzSz(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzC2.zzYF(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz2K.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX.zzZ(fieldType, updateField, this.zz4K(), this.zz4B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX.zzZ(fieldCode, this.zz4K(), this.zz4B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX.zzZ(fieldCode, fieldValue, this.zz4K(), this.zz4B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZ.zzZ((Object)displayText, "displayText");
        zzZ.zzZ((Object)urlOrBookmark, "hrefOrBookmark");
        zz3C zz3C2 = this.zzZ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zz3C2.zzY(documentBuilder.zzm(88, true));
        return zzX.zzZ(zz3C2.getStart(), zz3C2.getSeparator(), zz3C2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzNy(70);
        if (zzC2.zzYF(name)) {
            this.startBookmark(name);
        }
        this.zzSy(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzNx(70);
        String string = zzC2.zzYF(fieldValue) ? fieldValue : FormField.zzZ5I;
        Run run = new Run(this.zzZpO, string, this.zz4K());
        this.insertNode(run);
        this.zzm(70, true);
        if (zzC2.zzYF(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz8(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        return this.insertCheckBox(name, checkedValue, checkedValue, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzNy(71);
        if (zzC2.zzYF(name)) {
            this.startBookmark(name);
        }
        this.zzSy(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzm(71, false);
        if (zzC2.zzYF(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz8(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzNy(83);
        if (zzC2.zzYF(name)) {
            this.startBookmark(name);
        }
        this.zzSy(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzm(83, false);
        if (zzC2.zzYF(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zz8(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZpO, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX.zzU7(footnoteType));
        if (zzC2.zzYF(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZpO);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX.zzU6(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZpO, '\u0002', new zzZ0Q()) : new Run(this.zzZpO, footnote.getReferenceMark(), new zzZ0Q());
        inline.getFont().setStyleIdentifier(zzX.zzU7(footnoteType));
        paragraph.appendChild(inline);
        if (zzC2.zzYF(footnoteText)) {
            Node node = this.zz4B();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zz7(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzb(zz74 zz742) throws Exception {
        return this.zzZ(zz742, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzb(zz74.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz74 zz742, double d, double d2) throws Exception {
        return this.zzZ(zz742, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz74.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zz76 zz762 = new zz76();
        try {
            zzYH.zzZ(image, zz762);
            Shape shape = this.zzZ(zz762, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zz762.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzBL.zzYs(fileName);
        try {
            Shape shape = this.zzZ((zz74)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz74)object).close();
            }
        }
    }

    private Shape zzZ(zz74 zz742, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz742 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZ.zzZ(zz742);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz74.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZpO.getCompatibilityOptions().getMswVersion() > 12 || this.zzZpO.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzZpO, 0);
            zzDA zzDA2 = new zzDA();
            zzDA2.zzZ(zzFW.zzSU("rect"));
            zzDA2.zzZ(new zzMJ());
            zzDY zzDY2 = new zzDY();
            zzDY2.zzY(new zzE4(shape.getId(), ""));
            zzDY2.zzZ(new zzIA());
            zzDA2.zzZ(zzDY2);
            shape.zzM5(75);
            shape.zzX(zzDA2);
        } else {
            shape = new Shape((DocumentBase)this.zzZpO, 75);
        }
        shape.zzR(this.zz4K());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzA(width, height);
        return shape;
    }

    private Shape zzO(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz76 zz762 = new zz76();
        try {
            zzYH.zzZ(bufferedImage, zz762);
            byArray = zzZ.zzZ(zz762);
        }
        finally {
            zz762.close();
        }
        return this.zzZl(byArray);
    }

    private Shape zzZl(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZpO, 1);
        shape.zzM5(75);
        shape.zzR(this.zz4K());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzA(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        BufferedImage bufferedImage = presentation;
        boolean bl = asIcon;
        String string = progId;
        zz76 zz762 = zz74.zzY(stream);
        DocumentBuilder documentBuilder = this;
        zzZ8I zzZ8I2 = zzZ8I.zzLd(string);
        Shape shape = bufferedImage != null ? documentBuilder.zzO(bufferedImage) : documentBuilder.zzZl(zzZ8E.zzZ(zzZ8I2, bl));
        shape.zzM5(-2);
        shape.getOleFormat().setProgId(zzZ8I2.zzYrb);
        shape.getOleFormat().zzY(zzZ8E.zzZ(zz762, string, bl));
        return shape;
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ8I zzZ8I2 = zzZ8I.zzLc(zz75.zzXD(fileName));
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ8I2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ8I zzZ8I2 = zzZ8I.zzLd(progId);
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ8I2);
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZ8I zzZ8I2) throws Exception {
        Shape shape = bufferedImage != null ? this.zzO(bufferedImage) : this.zzZl(zzZ8E.zzZ(zzZ8I2, bl2));
        shape.zzM5(-2);
        shape.getOleFormat().setProgId(zzZ8I2.zzYrb);
        shape.getOleFormat().zzY(zzZ8E.zzZ(string, bl, bl2, zzZ8I2));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzZ(zzZUF zzZUF2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzO(bufferedImage);
        shape.zzM5(201);
        shape.getOleFormat().zzY(zzZUF2.zzZPf());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZV1 zzZV12 = new zzZV1();
        zzZV12.zzWB(useBuilderFormatting);
        zzZV12.zzWA(useBuilderFormatting);
        this.zzZ(html, zzZV12);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzX.zzZ(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzX.zzZ(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZRU zzZRU2 = new zzZRU();
        return zzZRU2.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYRX(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYRX(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZpO, 75);
        shape.zzR(this.zz4K());
        boolean bl = true;
        Shape shape2 = shape;
        if (!shape2.isSignatureLine()) {
            shape2.setShapeAttr(1983, true);
            shape2.setShapeAttr(1922, zz7D.zzdw.toString("B").toUpperCase());
        }
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzA(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public void insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzB(this.zzZpO);
        this.insertNode(shape);
    }

    private void zzZ(String string, zzZV1 zzZV12) throws Exception {
        Object object;
        Object object2 = this;
        boolean bl = false;
        if (((DocumentBuilder)object2).zz4B().getParentNode().getNodeType() == 28) {
            object = (StructuredDocumentTag)((DocumentBuilder)object2).zz4B().getParentNode();
            switch (((StructuredDocumentTag)object).getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        if (bl) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzSA(documentBuilder.getDocument().toString(70)));
            return;
        }
        object = this;
        zzZV1 zzZV13 = zzZV12;
        object2 = string;
        zzZWK zzZWK2 = new zzZWK((String)object2, zzZV13, (DocumentBuilder)object);
        zzZWK2.read();
    }

    private static String zzSA(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zz4E() == null) {
            this.startTable();
        }
        if (this.zz4E().zzZcK() == 1) {
            this.zz4E().zzZcN();
        }
        if (this.zz4E().zzZcK() == 3) {
            this.zz4E().zzZcL();
        }
        return this.zz4E().zzZcM();
    }

    public Table startTable() {
        this.zzZod.push(new zzYUY(this));
        return this.zz4E().startTable();
    }

    public Table endTable() {
        if (this.zz4E() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz4E().endTable();
        this.zzZod.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz4E() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz4E().endRow();
        if (this.zzZoh != null && this.zzZoh.getHidden()) {
            row.zz4A().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZpO, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZpO, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZpO);
        this.zzZob = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZob == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZpO, this.zzZob);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZpO, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return new zz96(this).zzZ(srcDoc, importFormatMode, 93);
    }

    public Document getDocument() {
        return this.zzZpO;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZpO) {
            return;
        }
        this.zzZpO = value;
        this.zz7(null);
        this.zzZoi = new zzZ0Q();
        this.zzZog = null;
        this.zzZoh = null;
        this.zzZod = new zz8F();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZoh == null) {
            this.zzZoh = new Font(this, this.getDocument());
        }
        return this.zzZoh;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZoe == null) {
            this.zzZoe = new RowFormat(this);
        }
        return this.zzZoe;
    }

    public CellFormat getCellFormat() {
        if (this.zzZWy == null) {
            this.zzZWy = new CellFormat(this);
        }
        return this.zzZWy;
    }

    public void pushFont() {
        this.zz4C().push(this.zz4K());
    }

    public void popFont() {
        zz8F<zzZ0Q> zz8F2 = this.zz4C();
        if (zz8F2.size() > 0) {
            this.zzZ((zzZ0Q)this.zz4C().pop(), false);
        }
    }

    private zz3C zzZ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzNy(88);
        zz37 zz372 = new zz37();
        zz372.setTarget(string2);
        zz372.setScreenTip(string3);
        if (bl) {
            zz372.setSubAddress(string);
        } else {
            zz372.setAddress(zzA8.zzYm(string));
            zz372.setSubAddress(zzA8.zzYl(string));
        }
        this.zzSy(zz372.toString());
        FieldSeparator fieldSeparator = this.zzNx(88);
        return new zz3C(fieldStart, fieldSeparator, null);
    }

    final zz3C zzS(String string, String string2, String string3) {
        boolean bl = zzA8.zzYd(string);
        String string4 = bl ? zzA8.zzYl(string) : string;
        return this.zzZ(string4, bl, string2, string3);
    }

    final FieldEnd zz4L() {
        return this.zzm(88, true);
    }

    final zzZ0Q zz4K() {
        return (zzZ0Q)this.zzZoi.zzyO();
    }

    final zzZ7K zz4J() {
        return (zzZ7K)this.getCurrentParagraph().zzZRN().zzyO();
    }

    final zzYUG zz4I() {
        return (zzYUG)this.zz4A().zzyO();
    }

    final zzYI zz4H() {
        return (zzYI)this.zzwC().zzyO();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz4B(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz4B().getNodeType() == 8;
    }

    private void zzH(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYPE.zzHS(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzSx(string2.substring(n, n + n2));
                }
                switch (this.zzZoc) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzSz(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzSx(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzSz(String string) {
        Run run = new Run(this.zzZpO, string, this.zz4K());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zz4E() != null && this.zz4E().zzZcK() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz4B().getParentNode().insertBefore(node, this.zz4B());
    }

    final void zzNA(int n) {
        this.zzXt(true);
        this.zzNz(n);
    }

    private void zzNz(int n) {
        this.insertParagraph();
        zzYVJ zzYVJ2 = new zzYVJ(this.getDocument());
        try {
            zzYZJ zzYZJ2 = (zzYZJ)this.getCurrentSection().zzZx0().zzyO();
            Section section = new Section(this.zzZpO, zzYZJ2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZpO));
            this.zzZpO.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYVJ2.dispose();
        }
    }

    final FieldStart zzNy(int n) {
        return zzX.zzZ(n, this.zz4K(), this.zz4B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzSy(String string) {
        return zzX.zzY(string, this.zz4K(), this.zz4B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzm(int n, boolean bl) {
        return zzX.zzY(n, bl, this.zz4K(), this.zz4B(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzNx(int n) {
        return zzX.zzY(n, this.zz4K(), this.zz4B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zz8(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZpO, new zzZZR(), this.zz4K());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzXt(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz4E() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ6(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzSx(String string) {
        boolean bl;
        block4: {
            String string2 = string;
            DocumentBuilder documentBuilder = this;
            boolean bl2 = documentBuilder.getFont().getBidi();
            for (int i = 0; i < string2.length(); ++i) {
                boolean bl3;
                char c = string2.charAt(i);
                int n = zzA9.zzy(c);
                boolean bl4 = n == 0;
                boolean bl5 = bl3 = n == 3 || n == 4;
                if ((!bl2 || !bl4) && (bl2 || !bl3)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            zzYU zzYU10 = new zzYU(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYT zzYT10 : zzYU10.zzK(this.getParagraphFormat().getBidi())) {
                zz7 zz710 = zz7.zzZq(zzYT10.zzYu());
                zzZ0Q zzZ0Q2 = this.zz4K();
                zzZ0Q2.zzT(265, zz710);
                if (zzYT10.zzYr()) {
                    zzZ0Q2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZpO, zzYT10.getText(), zzZ0Q2);
                this.insertNode(run);
            }
            return;
        }
        this.zzSz(string);
    }

    final void zzZ(zzZ0Q zzZ0Q2, boolean bl) {
        this.zzZoi = bl ? (zzZ0Q)zzZ0Q2.zzyO() : zzZ0Q2;
    }

    final void zz4G() {
        this.zzZoi.clear();
    }

    final void zz4F() {
        if (this.zz4D() != null) {
            zzYI zzYI2 = this.zz4D().zzwC();
            zzYI zzYI3 = this.zzZWz = (zzYI)zzYI2.zzyO();
            zzYI zzYI4 = zzYI2;
            for (int n : zzYI.zzZWg.zzDJ()) {
                if (zzYI4.contains(n)) {
                    Border border = new Border();
                    border.zzU((Border)zzYI4.get(n));
                    zzYI3.set(n, border);
                    continue;
                }
                zzYI3.remove(n);
            }
        }
    }

    final boolean zzbm() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final void zzNw(int n) {
        this.zzZoc = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz4B();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz4B();
        }
        return (Paragraph)this.zz4B().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYUY zz4E() {
        zz8F<zzYUY> zz8F2 = this.zzZod;
        if (zz8F2.size() > 0) {
            return (zzYUY)this.zzZod.peek();
        }
        return null;
    }

    private Cell zz4D() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZXy();
    }

    private zz8F<zzZ0Q> zz4C() {
        if (this.zzZog == null) {
            this.zzZog = new zz8F();
        }
        return this.zzZog;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZoi.zzTK(fontAttr);
    }

    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZoi.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZy(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZy(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZoi.zzT(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZs2()) {
            this.getCurrentParagraph().zzZsc().zzT(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZoi.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZoi.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZs2()) {
            this.getCurrentParagraph().zzZsc().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz4A().zzTK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz4A().zzTJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz4A().zzTI(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz4A().zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz4A().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz4A().clear();
        zzYUG.zzZbk().zzY(this.zz4A());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzwC().zzTK(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzwC().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzwC().zzTI(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zz4D() != null ? this.zz4D().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zzwC().zzT(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzwC().clear();
    }

    private Node zz4B() {
        Node node = this.zzZok != null && this.zzZok.getParentNode() == null ? this.zzZoj : this.zzZok;
        if (node != null && node.zzZAF() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zz7(Node node) {
        this.zzZok = node;
        if (this.zzZok != null) {
            this.zzZoj = this.zzZok.getParentNode();
        }
    }

    private zzYUG zz4A() {
        if (this.zz4E() != null && this.zz4E().zzZcK() == 1) {
            return this.zzZof;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz4A();
        }
        return this.zzZof;
    }

    private zzYI zzwC() {
        if (this.zz4E() != null && this.zz4E().zzZcK() != 3) {
            return this.zzZWz;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZXy().zzwC();
        }
        return this.zzZWz;
    }
}

